/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import java.util.Arrays;

public class PBEKeySpec
implements KeySpec {
    private char[] password;
    private byte[] salt = null;
    private int iterationCount = 0;
    private int keyLength = 0;

    public PBEKeySpec(char[] cArray) {
        this.password = cArray == null || cArray.length == 0 ? new char[0] : (char[])cArray.clone();
    }

    public PBEKeySpec(char[] cArray, byte[] byArray, int n, int n2) {
        this.password = cArray == null || cArray.length == 0 ? new char[0] : (char[])cArray.clone();
        if (byArray == null) {
            throw new NullPointerException("the salt parameter must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the salt parameter must not be empty");
        }
        this.salt = (byte[])byArray.clone();
        if (n <= 0) {
            throw new IllegalArgumentException("invalid iterationCount value");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid keyLength value");
        }
        this.iterationCount = n;
        this.keyLength = n2;
    }

    public PBEKeySpec(char[] cArray, byte[] byArray, int n) {
        this.password = cArray == null || cArray.length == 0 ? new char[0] : (char[])cArray.clone();
        if (byArray == null) {
            throw new NullPointerException("the salt parameter must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the salt parameter must not be empty");
        }
        this.salt = (byte[])byArray.clone();
        if (n <= 0) {
            throw new IllegalArgumentException("invalid iterationCount value");
        }
        this.iterationCount = n;
    }

    public final void clearPassword() {
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
    }

    public final char[] getPassword() {
        if (this.password == null) {
            throw new IllegalStateException("password has been cleared");
        }
        return (char[])this.password.clone();
    }

    public final byte[] getSalt() {
        if (this.salt != null) {
            return (byte[])this.salt.clone();
        }
        return null;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }
}

